#ifndef _CHATBOX_H_
#define _CHATBOX_H_


typedef struct CB_LINE
{
	char message[40];
	int player;
	int ts;
	
	struct CB_LINE *prev;
	struct CB_LINE *next;
} CB_LINE;

typedef struct CHATBOX
{
	CB_LINE *head;
	CB_LINE *current;
	BITMAP *bmp;
	GFX_OVERLAY *overlay;

	int auto_advance;
} CHATBOX;

extern CHATBOX *chatbox;

void chatbox_init(void);
void chatbox_add(int player, char *message);
void chatbox_shutdown(void);
void chatbox_draw(void);
void chatbox_update(void);
void chatbox_previous(void);
void chatbox_next(void);

#endif